package eu.europa.ec.taxud.cesop.readers;

import java.util.Iterator;

import eu.europa.ec.taxud.cesop.domain.PaymentDataMsgPartContentType;
import eu.europa.ec.taxud.cesop.domain.XmlMessageSpec;
import eu.europa.ec.taxud.cesop.domain.XmlPaymentDataMsgPart;
import eu.europa.ec.taxud.cesop.domain.XmlPsp;

/**
 * Iterative reader of Payment Service Provider xml files.
 */
public interface IPspXmlReader extends Iterator<XmlPaymentDataMsgPart>, AutoCloseable {
    /**
     * Returns parsed MessageSpec part. Available at any point of iteration.
     *
     * @return the xml message spec
     */
    XmlMessageSpec getXmlMessageSpec();

    /**
     * Returns parsed MessageSpec part. Available at any point of iteration.
     *
     * @return the xml reporting psp
     */
    XmlPsp getXmlReportingPsp();

    /**
     * Parse the next part of payment data.
     * For every payee it first yields one or more parts with {@link PaymentDataMsgPartContentType#REPORTED_TRANSACTIONS} type.
     * Then, after all payee transactions are produced, one {@link PaymentDataMsgPartContentType#REPORTED_PAYEE} part is yielded.
     */
    @Override
    XmlPaymentDataMsgPart next();

    /**
     * Gets estimated content size.
     *
     * @return returns content size in bytes if available. If not, returns -1.
     */
    long getEstimatedContentSize();
}
